//scilab 5.5.2 , OS: Ubuntu 14.04
//Program To Design the Digtial Chebyshev IIR Filter 
////Design example:
//Design a digital IIR low pass filter with following specifications.
//a) Pass band cut-off frequency     :1000 Hz
//b) Pass band ripple                       :-1 dB
//c) Stop band cut-off frequency     :3000 rad
//d) Stop band attenuation               : -15 dB
//Sampling frequency: 15000 Hz

clear all;clc;close;
f1=1000;//input('Enter the pass band edge(Hz)= ');
f2=3000;//input('Enter the stop band edge(Hz)= ');
rp=-1;//input('Enter the pass band ripple(dB)= ');
rs=-15;//input('Enter the stop band attenuation(dB)= ');
fs=10000;//input('Enter the sampling rate(Hz)= ');
//Digital filter specifications(rad)
w1=2*%pi*f1*1/fs
w2=2*%pi*f2*1/fs
//Pre warping
o1=2*fs*tan(w1/2)
o2=2*fs*tan(w2/2)
or=o2/o1;//Stop-band edge of normalized lowpass filter
A2 =10.^(-rs/10);
A=sqrt(A2);    
epsilon2 = (10.^(-rp/10)-1);
epsilon=sqrt(epsilon2)
g=((A2-1).^0.5./epsilon)

N = (acosh(g))/(acosh(or))
N = ceil(N)
oc=o1;
//[pols,gn] = zpch1(N,epsilon,o1)
//Hs = poly(gn,'s','coeff')/real(poly(pols,'s'))
h=cheb1mag(N,oc,epsilon,1:2*%pi*fs);
mag=20*log10(h)';
//plot2d((1:1000)',mag,[2],"011"," ",[ymax,ymin,fmax,fmin])
//gain=20*log10(abs(h_s)); %Verify the specification [k1,k2] at prewarped frequencies 
//subplot(211); 
//plot(omega,gain);
//xlabel(‘frequency in rad/sec’);
//Converting analog to digital filter 
fc=w1/(2*%pi);
delta1=(1-(1./A2));
//1-ripple in passband
hz=iir(N,'lp','cheb1',[fc],[delta1 0]);
//for cheb1 filters 1-delta(1)<ripple<1 in passband
//g*poly(z,'z')/poly(p,'z')
[hzm,fr]=frmag(hz,256);
magz=20*log10(hzm)';
figure(1);subplot(2,1,1),plot2d((1:2*%pi*fs)',mag),xtitle('Analog IIR filter: lowpass','Analog frequency in rads/sec', 'dB',' ');subplot(2,1,2),plot2d(fr,magz);xtitle('Digital IIR filter: lowpass 0 < fr < 0.5','frequency', 'dB',' ');
